<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Best Adventure Activities in Chikmagalur - Misty Peaks</title>
    <meta name="description" content="The Mathias coffee plantation , surrounded by thick green valleys , Silver Oak trees , Areca palms and majestic mountains is an ideal setting for a relaxing holiday. It is here that nature calls you to forget the stressful , hectic and monotonous city life and plunge into a world of surreal beauty.">
    <meta name="keywords" content="adventure activities in chikmagalur">
	  <meta name="copyright" content="Copyright &copy; 2021 Misty Peaks All Rights Reserved">
	  <meta name="author" content="Misty Peaks">
	  <meta name="zipcode" content="575018">
	  <meta name="city" content="Mangalore">
	  <meta name="country" content="India">
    <meta name="robots" content="All">
	  <meta name="robots" content="ODP (Default)">
    <link rel="shortcut icon" href="img/icon.ico"/>
    <link href="css/bootstrap.min.css" rel="stylesheet"/>
    <link href="css/misty-peaks.css" rel="stylesheet"/>
    <!--Main Menu File-->
    <link id="effect" rel="stylesheet" type="text/css" media="all" href="css/dropdown-effects/fade-down.css" />
    <link rel="stylesheet" type="text/css" media="all" href="css/menu.css" />
    <link id="theme" rel="stylesheet" type="text/css" media="all" href="css/color-skins/white-red.css" />
    <!-- FontAwesome -->
    <link href="css/all.css" rel="stylesheet"/>
    <link href="css/font-awesome-animation.min.css" rel="stylesheet"/>
    <!-- Animation -->
    <link rel="stylesheet" href="css/animate.css"/>
    <link rel="stylesheet" href="css/magnific/magnific-popup.css"/>
    <!-- Owl Stylesheets -->
    <link rel="stylesheet" href="css/owl.carousel.min.css"/>
    <link rel="stylesheet" href="css/owl.theme.default.min.css"/>
</head>
<body>

<?php include('header.php')?>

<section class="inner-banner">
  <div class="col-xs-12 col-sm-12 col-md-12 logo wow fadeInLeft">
    <img src="img/misty-peaks-logo.png" class="img-fluid"/>
  </div>
  <div class="row">
    <img src="img/banner/1.jpg" alt="" class="img-fluid"/>
  </div>
</section>
<section class="about-content wp-block-cover-image">
  <div class="container">
    <h1 class="wow fadeInDown">Activities</h1>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 p-0 wow fadeInLeft">
          <div class="activity-img">
            <img src="img/walking-trek-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
        <div class="col-md-6 activity-content wow fadeInRight">
            <h2>Hiking</h2>
            <p>If you are into fitness you can enjoy a trek along the steep terrain of the estate. Walking alongside the coffee plants will surely turn out to be a soothing and soul searching experience.</p>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 activity-content wow fadeInLeft Morder-2">
            <h2>Campfire and Music</h2>
            <p>Enjoy the cool mist and the evening breeze sitting by a campfire. Go down memory lane or make new memories as you listen to music and take in the beautiful night time setting.</p>
        </div>
        <div class="col-md-6 p-0 wow fadeInRight Morder-1">
          <div class="activity-img">
            <img src="img/campfire-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 p-0 wow fadeInLeft">
          <div class="activity-img">
            <img src="img/coffee-plantation-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
        <div class="col-md-6 activity-content wow fadeInRight">
            <h2>Coffee Plantation Walk</h2>
            <p>Take a walk into our plantation to learn more about coffee and its history . The surrounding greenery and the aromatic smell of coffee blossoms and beans is sure soothe your mind.</p>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 activity-content wow fadeInLeft">
            <h2>Bird Watching</h2>
            <p>Treat your ears to the sweet chirping of the innumerous birds in the estate. Feast your eyes to the kaleidoscope of colours flying around. A birdwatchers dream.</p>
        </div>
        <div class="col-md-6 p-0 wow fadeInRight">
          <div class="activity-img">
            <img src="img/bird-watching-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 p-0 wow fadeInLeft">
          <div class="activity-img">
            <img src="img/outdoor-games-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
        <div class="col-md-6 activity-content wow fadeInRight">
            <h2>Outdoor Games</h2>
            <p>Cricket, badminton, volleyball and basketball are available at your disposal if you are in a mood for a friendly match or some adrenaline pumping fun.</p>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 activity-content wow fadeInLeft">
            <h2>Indoor Games</h2>
            <p>Sit back with your hot cuppa and bond deeper with your family and friends as you play our indoor boardgames in a quaint comfortable setting.</p>
        </div>
        <div class="col-md-6 p-0 wow fadeInRight">
          <div class="activity-img">
            <img src="img/indoor-games-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 p-0 wow fadeInLeft">
          <div class="activity-img">
            <img src="img/meditation-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
        <div class="col-md-6 activity-content wow fadeInRight">
            <h2>Meditation</h2>
            <p>For the early risers enjoy the tranquill setting amidst the mountains for peaceful meditation and yoga.</p>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 activity-content wow fadeInLeft">
            <h2>Biking</h2>
            <p>Take a bicycle ride along the picturesque terrain of the plantations. Bicycles available on request.</p>
        </div>
        <div class="col-md-6 p-0 wow fadeInRight">
          <div class="activity-img">
            <img src="img/biking-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 p-0 wow fadeInLeft">
          <div class="activity-img">
            <img src="img/library-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
        <div class="col-md-6 activity-content wow fadeInRight">
            <h2>Library</h2>
            <p>For the bookworm in you ,our extensive library is filled with a wide array of books. Nothing like spending your time surrounded by greenery, Book in hand and a hot cuppa by your side.</p>
        </div>
      </div>
      <div class="col-md-12 d-inline-flex justify-content-center align-items-center p-0 inner-activity-bg">
        <div class="col-md-6 activity-content wow fadeInLeft">
            <h2>Kids Play Area</h2>
            <p>The kids can be kept occupied and out of your hair in the kids play area. Safe, state of the art play equipment has been installed next to the recreation room so that you can relax and keep an eye on the kids at the same time.</p>
        </div>
        <div class="col-md-6 p-0 wow fadeInRight">
          <div class="activity-img">
            <img src="img/kids-play-area-banner.jpg" class="img-fluid img-thumbnail"/>
          </div>
        </div>
      </div>

  </div>
</section>


<!-- <?php include('common-bottom-tariff.php') ?> -->
<?php include('common-contact.php')?>
<?php include("footer-common-js.php") ?>
<?php include("footer.php") ?>
</body>
</html>
